/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.ammobench;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCount;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCountType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class AddRangeOutputCount
implements AmmoBenchOutputCount {
    private static final Random RANDOM = new Random();
    private final int value;
    @Nullable
    private final Float chance;

    public AddRangeOutputCount(int value, @Nullable Float chance) {
        this.value = value;
        this.chance = chance;
    }

    @Override
    public int getCount(int count) {
        if (this.chance != null && RANDOM.nextFloat() >= this.chance.floatValue()) {
            return count;
        }
        return count + this.value;
    }

    @Override
    public AmmoBenchOutputCountType<?> getType() {
        return AmmoBenchOutputCountType.ADD;
    }

    public static final class Serializer
    implements AmmoBenchOutputCountType.AmmoBenchOutputCountSerializer<AddRangeOutputCount> {
        @Override
        public AddRangeOutputCount parseJson(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            int value = JSONUtils.func_151203_m((JsonObject)object, (String)"value");
            Float chance = JsonHelper.optionally(object, "chance", JSONUtils::func_151217_k).orElse(null);
            return new AddRangeOutputCount(value, chance);
        }

        @Override
        public void toNetwork(AddRangeOutputCount addRangeOutputCount, PacketBuffer buffer) {
            buffer.writeInt(addRangeOutputCount.value);
            buffer.writeBoolean(addRangeOutputCount.chance != null);
            if (addRangeOutputCount.chance != null) {
                buffer.writeFloat(addRangeOutputCount.chance.floatValue());
            }
        }

        @Override
        public AddRangeOutputCount fromNetwork(PacketBuffer buffer) {
            int value = buffer.readInt();
            Float chance = buffer.readBoolean() ? Float.valueOf(buffer.readFloat()) : null;
            return new AddRangeOutputCount(value, chance);
        }

        @Override
        public CompoundNBT toNbt(AddRangeOutputCount addRangeOutputCount) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("value", addRangeOutputCount.value);
            if (addRangeOutputCount.chance != null) {
                nbt.func_74776_a("chance", addRangeOutputCount.chance.floatValue());
            }
            return nbt;
        }

        @Override
        public AddRangeOutputCount fromNbt(CompoundNBT nbt) {
            int value = nbt.func_74762_e("value");
            Float chance = nbt.func_74764_b("chance") ? Float.valueOf(nbt.func_74760_g("chance")) : null;
            return new AddRangeOutputCount(value, chance);
        }
    }
}

